/*
 * Decompiled with CFR 0.152.
 */
package fr.asip.cps3.exemple.modele;

import fr.asip.cps3.exemple.modele.MenuApplication;
import fr.asip.cps3.exemple.modele.ecouteurs.ApplicationEcouteur;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionLibrairie;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionObjet;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionProgrammeExemple;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionVue;
import fr.asip.cps3.exemple.modele.jni.ConnecteurJNI;
import fr.asip.cps3.exemple.modele.jni.TraitementsSpecifiques;
import fr.asip.cps3.exemple.modele.objets.Algo;
import fr.asip.cps3.exemple.modele.objets.Cle;
import fr.asip.cps3.exemple.modele.objets.Objet;
import fr.asip.cps3.exemple.modele.objets.Session;
import fr.asip.cps3.exemple.modele.objets.Slot;
import fr.asip.cps3.exemple.modele.objets.Token;
import fr.asip.cps3.exemple.modele.resultats.Resultat;
import fr.asip.cps3.exemple.vues.menus.ItemMenu;
import fr.asip.cps3.exemple.vues.menus.Menu;
import iaik.pkcs.pkcs11.wrapper.CK_INFO;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Connector;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.event.EventListenerList;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Application {
    private static Logger log = Logger.getLogger(Application.class);
    private Properties fichierProperties;
    private MenuApplication menu;
    private PKCS11 librairieP11;
    private TraitementsSpecifiques traitementsSpecifiques;
    private String cheminLibrairieP11;
    private String cheminLibrairieTS;
    private CK_INFO infoLibrairieP11;
    private EventListenerList ecouteurs;
    private Vector<Slot> slots = new Vector();
    private Vector<Token> tokens = new Vector();
    private TreeMap<String, Vector<Algo>> algos = new TreeMap();
    private TreeMap<String, Vector<Session>> sessions = new TreeMap();
    private Session sessionCourante;
    private TreeMap<String, Vector<Cle>> clesPubliques = new TreeMap();
    private TreeMap<String, Vector<Cle>> clesPrivees = new TreeMap();
    private TreeMap<String, Vector<Objet>> objets = new TreeMap();
    private Vector<String> filtresObjets = new Vector();
    private String signatureMessage;
    private String signatureFichier;
    private char[] messageSigne;
    private String fichierSigne;

    public Application(String string) throws FileNotFoundException, IOException {
        this.fichierProperties = new Properties();
        this.fichierProperties.load(this.getClass().getResourceAsStream("/programmeExemple.properties"));
        this.menu = new MenuApplication();
        this.cheminLibrairieP11 = string;
        this.cheminLibrairieTS = this.fichierProperties.getProperty("cheminLibrairieTS." + Application.getTypeOS());
        try {
            this.chargerLibrairie();
        }
        catch (Throwable throwable) {
            log.error((Object)throwable.getLocalizedMessage());
        }
        if (this.librairieP11 != null) {
            this.chargerInfoLibrairie();
            this.ecouteurs = new EventListenerList();
        }
    }

    public Application() throws FileNotFoundException, IOException {
        this.fichierProperties = new Properties();
        this.fichierProperties.load(this.getClass().getResourceAsStream("/programmeExemple.properties"));
        if (this.fichierProperties != null) {
            this.cheminLibrairieP11 = this.fichierProperties.getProperty("cheminLibrairieP11." + Application.getTypeOS());
            this.cheminLibrairieTS = this.fichierProperties.getProperty("cheminLibrairieTS." + Application.getTypeOS());
            this.menu = new MenuApplication();
            try {
                this.chargerLibrairie();
            }
            catch (Throwable throwable) {
                log.error((Object)throwable.getLocalizedMessage());
            }
            if (this.librairieP11 != null) {
                this.chargerInfoLibrairie();
                this.ecouteurs = new EventListenerList();
            }
        }
    }

    public Properties getFichierProperties() {
        return this.fichierProperties;
    }

    public MenuApplication getMenu() {
        return this.menu;
    }

    public void setMenu(MenuApplication menuApplication) {
        this.menu = menuApplication;
    }

    public Menu getMenu(String string) {
        if (this.menu != null && this.menu.getItemsMenus() != null) {
            JMenuItem jMenuItem = this.menu.getItemsMenus().get(string);
            return jMenuItem instanceof Menu ? (Menu)jMenuItem : null;
        }
        return null;
    }

    public ItemMenu getItemMenu(String string) {
        if (this.menu != null && this.menu.getItemsMenus() != null) {
            JMenuItem jMenuItem = this.menu.getItemsMenus().get(string);
            return jMenuItem instanceof ItemMenu ? (ItemMenu)jMenuItem : null;
        }
        return null;
    }

    public String getCheminLibrairieP11() {
        return this.cheminLibrairieP11;
    }

    public PKCS11 getLibrairieP11() {
        return this.librairieP11;
    }

    public String getVersion() {
        return this.fichierProperties != null && this.fichierProperties.getProperty("version") != null ? this.fichierProperties.getProperty("version") : "";
    }

    public void setLibrairieP11(String string) {
        block3: {
            try {
                this.cheminLibrairieP11 = string;
                this.chargerLibrairie();
            }
            catch (Throwable throwable) {
                if (!(throwable instanceof ExceptionLibrairie)) break block3;
                this.notifieProblemeMAJLibrairieP11(((ExceptionLibrairie)throwable).getCodeException());
            }
        }
        this.chargerInfoLibrairie();
        this.notifieMAJLibrairieP11();
        if (this.traitementsSpecifiques != null) {
            this.getMenu().setItemMenuActif("1");
        }
    }

    public TraitementsSpecifiques getTraitementsSpecifiques() {
        return this.traitementsSpecifiques;
    }

    public CK_INFO getInfoLibrairieP11() {
        return this.infoLibrairieP11;
    }

    public void setInfoLibrairieP11(CK_INFO cK_INFO) {
        this.infoLibrairieP11 = cK_INFO;
    }

    public Vector<Slot> getSlots() {
        return this.slots;
    }

    public Vector<Token> getTokens() {
        return this.tokens;
    }

    public TreeMap<String, Vector<Algo>> getAlgo() {
        return this.algos;
    }

    public TreeMap<String, Vector<Session>> getSessions() {
        return this.sessions;
    }

    public Session getSessionCourante() {
        return this.sessionCourante;
    }

    public void setSessionCourante(Session session) {
        this.sessionCourante = session;
        this.declencheMAJMenus();
    }

    public TreeMap<String, Vector<Cle>> getClesPrivees() {
        return this.clesPrivees;
    }

    public TreeMap<String, Vector<Cle>> getClesPubliques() {
        return this.clesPubliques;
    }

    public TreeMap<String, Vector<Objet>> getObjets() {
        return this.objets;
    }

    public Vector<String> getFiltresObjets() {
        return this.filtresObjets;
    }

    public void ajouteFiltreObjet(String string) {
        if (!this.filtresObjets.contains(string)) {
            this.filtresObjets.add(string);
        }
    }

    public void supprimeTousLesFiltresObjets() {
        this.filtresObjets.clear();
    }

    public String getSignatureMessage() {
        return this.signatureMessage;
    }

    public void setSignatureMessage(String string) {
        this.signatureMessage = string;
    }

    public String getSignatureFichier() {
        return this.signatureFichier;
    }

    public void setSignatureFichier(String string) {
        this.signatureFichier = string;
    }

    public char[] getMessageSigne() {
        return this.messageSigne;
    }

    public void setMessageSigne(char[] cArray) {
        this.messageSigne = cArray;
    }

    public String getFichierSigne() {
        return this.fichierSigne;
    }

    public void setFichierSigne(String string) {
        this.fichierSigne = string;
    }

    public void declencheAffichageResultat(Resultat resultat) throws ExceptionVue {
        if (this.ecouteurs != null) {
            ApplicationEcouteur[] applicationEcouteurArray;
            for (ApplicationEcouteur applicationEcouteur : applicationEcouteurArray = (ApplicationEcouteur[])this.ecouteurs.getListeners(ApplicationEcouteur.class)) {
                applicationEcouteur.afficheResultat(resultat);
            }
        }
    }

    public void declencheAffichageEcran(int n) throws ExceptionVue {
        if (this.ecouteurs != null) {
            ApplicationEcouteur[] applicationEcouteurArray;
            for (ApplicationEcouteur applicationEcouteur : applicationEcouteurArray = (ApplicationEcouteur[])this.ecouteurs.getListeners(ApplicationEcouteur.class)) {
                applicationEcouteur.afficheEcran(n);
            }
        }
    }

    public void declencheAffichageEcran(int n, Object object) throws ExceptionVue {
        if (this.ecouteurs != null) {
            ApplicationEcouteur[] applicationEcouteurArray;
            for (ApplicationEcouteur applicationEcouteur : applicationEcouteurArray = (ApplicationEcouteur[])this.ecouteurs.getListeners(ApplicationEcouteur.class)) {
                applicationEcouteur.afficheEcran(n, object);
            }
        }
    }

    public void declencheMAJMenus() {
        if (this.ecouteurs != null) {
            ApplicationEcouteur[] applicationEcouteurArray;
            for (ApplicationEcouteur applicationEcouteur : applicationEcouteurArray = (ApplicationEcouteur[])this.ecouteurs.getListeners(ApplicationEcouteur.class)) {
                applicationEcouteur.majMenus(this);
            }
        }
    }

    public void notifieException(Exception exception) {
        if (this.ecouteurs != null) {
            ApplicationEcouteur[] applicationEcouteurArray;
            for (ApplicationEcouteur applicationEcouteur : applicationEcouteurArray = (ApplicationEcouteur[])this.ecouteurs.getListeners(ApplicationEcouteur.class)) {
                applicationEcouteur.afficheException(exception);
            }
        }
    }

    private void notifieProblemeMAJLibrairieP11(int n) {
        if (this.ecouteurs != null) {
            ApplicationEcouteur[] applicationEcouteurArray;
            for (ApplicationEcouteur applicationEcouteur : applicationEcouteurArray = (ApplicationEcouteur[])this.ecouteurs.getListeners(ApplicationEcouteur.class)) {
                applicationEcouteur.problemeChargementLibrairie(n, this);
            }
        }
    }

    public void notifieMAJLibrairieP11() {
        if (this.ecouteurs != null) {
            ApplicationEcouteur[] applicationEcouteurArray;
            for (ApplicationEcouteur applicationEcouteur : applicationEcouteurArray = (ApplicationEcouteur[])this.ecouteurs.getListeners(ApplicationEcouteur.class)) {
                applicationEcouteur.chargementLibrairie(new String(this.infoLibrairieP11.libraryDescription).trim());
            }
        }
    }

    public int declencheDemandeConnexionLecteur() {
        ApplicationEcouteur[] applicationEcouteurArray;
        ApplicationEcouteur[] applicationEcouteurArray2;
        int n;
        int n2;
        if (this.ecouteurs != null && (n2 = 0) < (n = (applicationEcouteurArray2 = (applicationEcouteurArray = (ApplicationEcouteur[])this.ecouteurs.getListeners(ApplicationEcouteur.class))).length)) {
            ApplicationEcouteur applicationEcouteur = applicationEcouteurArray2[n2];
            return applicationEcouteur.demandeConnexionLecteur();
        }
        return 0;
    }

    public int declencheDemandeInsertionCarte() {
        ApplicationEcouteur[] applicationEcouteurArray;
        ApplicationEcouteur[] applicationEcouteurArray2;
        int n;
        int n2;
        if (this.ecouteurs != null && (n2 = 0) < (n = (applicationEcouteurArray2 = (applicationEcouteurArray = (ApplicationEcouteur[])this.ecouteurs.getListeners(ApplicationEcouteur.class))).length)) {
            ApplicationEcouteur applicationEcouteur = applicationEcouteurArray2[n2];
            return applicationEcouteur.demandeInsertionCarte();
        }
        return 0;
    }

    public Object[] declencheDemandeSaisieCodePorteur(long l, long l2, String string) {
        ApplicationEcouteur[] applicationEcouteurArray;
        ApplicationEcouteur[] applicationEcouteurArray2;
        int n;
        int n2;
        if (this.ecouteurs != null && (n2 = 0) < (n = (applicationEcouteurArray2 = (applicationEcouteurArray = (ApplicationEcouteur[])this.ecouteurs.getListeners(ApplicationEcouteur.class))).length)) {
            ApplicationEcouteur applicationEcouteur = applicationEcouteurArray2[n2];
            return applicationEcouteur.demandeSaisieCodePorteur(l, l2, string);
        }
        return null;
    }

    public Object[] declencheDemandeRecyclageCodePorteur(long l, long l2, long l3, String string) {
        ApplicationEcouteur[] applicationEcouteurArray;
        ApplicationEcouteur[] applicationEcouteurArray2;
        int n;
        int n2;
        if (this.ecouteurs != null && (n2 = 0) < (n = (applicationEcouteurArray2 = (applicationEcouteurArray = (ApplicationEcouteur[])this.ecouteurs.getListeners(ApplicationEcouteur.class))).length)) {
            ApplicationEcouteur applicationEcouteur = applicationEcouteurArray2[n2];
            return applicationEcouteur.demandeRecyclageCodePorteur(l, l2, l3, string);
        }
        return null;
    }

    public int declencheDemandeChoixNbEssaisPossiblesAvantBlocageCodePorteur() {
        ApplicationEcouteur[] applicationEcouteurArray;
        ApplicationEcouteur[] applicationEcouteurArray2;
        int n;
        int n2;
        if (this.ecouteurs != null && (n2 = 0) < (n = (applicationEcouteurArray2 = (applicationEcouteurArray = (ApplicationEcouteur[])this.ecouteurs.getListeners(ApplicationEcouteur.class))).length)) {
            ApplicationEcouteur applicationEcouteur = applicationEcouteurArray2[n2];
            return applicationEcouteur.demandeChoixNbEssaisPossiblesAvantBlocageCodePorteur();
        }
        return 0;
    }

    public int declencheDemandeActionLecteurCarte(int n, String string) {
        ApplicationEcouteur[] applicationEcouteurArray;
        ApplicationEcouteur[] applicationEcouteurArray2;
        int n2;
        int n3;
        if (this.ecouteurs != null && (n3 = 0) < (n2 = (applicationEcouteurArray2 = (applicationEcouteurArray = (ApplicationEcouteur[])this.ecouteurs.getListeners(ApplicationEcouteur.class))).length)) {
            ApplicationEcouteur applicationEcouteur = applicationEcouteurArray2[n3];
            return applicationEcouteur.demandeActionLecteurCarte(n, string);
        }
        return 0;
    }

    public void declencheAlerteCarteRetrouvee() {
        if (this.ecouteurs != null) {
            ApplicationEcouteur[] applicationEcouteurArray;
            for (ApplicationEcouteur applicationEcouteur : applicationEcouteurArray = (ApplicationEcouteur[])this.ecouteurs.getListeners(ApplicationEcouteur.class)) {
                applicationEcouteur.declencheAlerteCarteRetrouvee();
            }
        }
    }

    public Object[] declencheDemandeModificationObjetDonneesApplicatives(byte[] byArray) {
        ApplicationEcouteur[] applicationEcouteurArray;
        ApplicationEcouteur[] applicationEcouteurArray2;
        int n;
        int n2;
        if (this.ecouteurs != null && (n2 = 0) < (n = (applicationEcouteurArray2 = (applicationEcouteurArray = (ApplicationEcouteur[])this.ecouteurs.getListeners(ApplicationEcouteur.class))).length)) {
            ApplicationEcouteur applicationEcouteur = applicationEcouteurArray2[n2];
            return applicationEcouteur.declencheDemandeModificationObjetDonneesApplicatives(byArray);
        }
        return null;
    }

    private void chargerLibrairie() throws ExceptionLibrairie {
        if (this.librairieP11 != null) {
            try {
                this.librairieP11.C_Finalize(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.librairieP11 = PKCS11Connector.connectToPKCS11Module((String)this.cheminLibrairieP11);
        }
        catch (Throwable throwable) {
            log.error((Object)("Une erreur est survenue au chargement de la librairie PKCS#11 : " + throwable.getMessage()));
            throw new ExceptionLibrairie(502, "Une erreur est survenue au chargement de la librairie PKCS#11");
        }
        try {
            this.traitementsSpecifiques = ConnecteurJNI.connecteAuModulePKCS11(this, this.cheminLibrairieTS, this.cheminLibrairieP11);
        }
        catch (Throwable throwable) {
            log.error((Object)("Une erreur est survenue au chargement de la librairie native des traitements sp\u00e9cifiques : " + throwable.getMessage()));
            throw new ExceptionLibrairie(502, "Une erreur est survenue au chargement de la librairie native des traitements sp\u00e9cifiques. Le module traitements sp\u00e9cifiques est inutilisable.");
        }
    }

    private void chargerInfoLibrairie() {
        try {
            this.librairieP11.C_Initialize(null);
            this.infoLibrairieP11 = this.librairieP11.C_GetInfo();
            this.librairieP11.C_Finalize(null);
        }
        catch (PKCS11Exception pKCS11Exception) {
            log.error((Object)("Une erreur est survenue au chargement des informations de la librairie PKCS11 : " + ExceptionProgrammeExemple.getStacktrace(pKCS11Exception)));
        }
    }

    public void ajouteLesSlots(Vector<Object> vector, boolean bl) throws ExceptionObjet, PKCS11Exception {
        if (this.slots == null) {
            this.slots = new Vector();
        }
        Iterator<Object> iterator = vector.iterator();
        while (iterator.hasNext()) {
            long l = (Long)iterator.next();
            Slot slot = new Slot(this.librairieP11, l);
            this.slots.add(slot);
            if (!bl || (this.librairieP11.C_GetSlotInfo((long)l).flags & 1L) == 0L) continue;
            if (this.tokens == null) {
                this.tokens = new Vector();
            }
            this.tokens.add(new Token(this.librairieP11, l));
        }
    }

    public void ajouteLesTokens(Vector<Object> vector) throws ExceptionObjet {
        Iterator<Object> iterator = vector.iterator();
        while (iterator.hasNext()) {
            Token token = new Token(this.librairieP11, (Long)iterator.next());
            if (this.tokens == null) {
                this.tokens = new Vector();
            }
            this.tokens.add(token);
        }
    }

    public void ajouteLesAlgo(Token token, Vector<Object> vector) throws ExceptionObjet {
        Iterator<Object> iterator = vector.iterator();
        while (iterator.hasNext()) {
            Algo algo = new Algo(this.librairieP11, token.getIdSlotToken(), (Long)iterator.next());
            if (this.algos == null) {
                this.algos = new TreeMap();
            }
            if (this.algos.get(token.getNumeroSerie()) == null) {
                this.algos.put(token.getNumeroSerie(), new Vector());
            }
            this.algos.get(token.getNumeroSerie()).add(algo);
        }
    }

    public void ajouteLesObjets(PKCS11 pKCS11, Session session, String string, Vector<Object> vector, int n) throws ExceptionObjet {
        Vector<Long> vector2 = new Vector<Long>();
        for (Object object : vector) {
            long[] lArray;
            if (n == 2) {
                lArray = (long[])object;
                if (this.clesPubliques == null) {
                    this.clesPubliques = new TreeMap();
                }
                if (this.clesPubliques.get(string) == null) {
                    this.clesPubliques.put(string, new Vector());
                }
                this.clesPubliques.get(string).add(new Cle(pKCS11, session.getIdSession(), lArray[0], lArray[1]));
                continue;
            }
            if (n == 3) {
                lArray = (long[])object;
                if (this.clesPrivees == null) {
                    this.clesPrivees = new TreeMap();
                }
                if (this.clesPrivees.get(string) == null) {
                    this.clesPrivees.put(string, new Vector());
                }
                this.clesPrivees.get(string).add(new Cle(pKCS11, session.getIdSession(), lArray[0], lArray[1]));
                continue;
            }
            if (n != 4) continue;
            if (this.objets == null) {
                this.objets = new TreeMap();
            }
            if (this.objets.get(string) == null) {
                this.objets.put(string, new Vector());
            }
            if (vector2.contains((Long)object)) continue;
            this.objets.get(string).add(new Objet(pKCS11, session.getIdSession(), (Long)object));
            vector2.add((Long)object);
        }
    }

    public void ajouteLaSession(Token token, long l) throws ExceptionObjet {
        if (token != null && token.getNumeroSerie() != null) {
            Session session = new Session(this.librairieP11, token.getNumeroSerie(), l);
            if (this.sessions == null) {
                this.sessions = new TreeMap();
            }
            if (this.sessions.get(token.getNumeroSerie()) == null) {
                this.sessions.put(token.getNumeroSerie(), new Vector());
            }
            this.sessions.get(token.getNumeroSerie()).add(session);
            this.sessionCourante = session;
        }
    }

    public void ajouteApplicationEcouteur(ApplicationEcouteur applicationEcouteur) {
        if (this.ecouteurs != null) {
            this.ecouteurs.add(ApplicationEcouteur.class, applicationEcouteur);
        }
    }

    public void supprimeTousLesElementsEnCours() {
        if (this.slots != null) {
            this.slots.removeAllElements();
        }
        if (this.tokens != null) {
            this.tokens.removeAllElements();
        }
        if (this.algos != null) {
            this.algos.clear();
        }
        if (this.sessions != null) {
            this.sessions.clear();
        }
        if (this.clesPubliques != null) {
            this.clesPubliques.clear();
        }
        if (this.clesPrivees != null) {
            this.clesPrivees.clear();
        }
        if (this.objets != null) {
            this.objets.clear();
        }
        this.sessionCourante = null;
        this.signatureMessage = null;
        this.signatureFichier = null;
        this.messageSigne = null;
        this.fichierSigne = null;
    }

    public void supprimeTousLesAlgo(String string) {
        if (this.algos != null && this.algos.get(string) != null) {
            this.algos.get(string).removeAllElements();
        }
    }

    public void supprimeObjet(String string, Objet objet) {
        if (string != null && objet != null && this.objets != null && this.objets.get(string) != null) {
            this.objets.get(string).remove(objet);
        }
    }

    public void supprimeTousLesObjets(String string) {
        this.supprimeTousLesObjetsDeType(string, 3);
        this.supprimeTousLesObjetsDeType(string, 2);
        this.supprimeTousLesObjetsDeType(string, 4);
    }

    public void supprimeTousLesObjetsDeType(String string, int n) {
        if (n == 2) {
            if (this.clesPubliques != null && this.clesPubliques.get(string) != null) {
                this.clesPubliques.get(string).removeAllElements();
            }
        } else if (n == 3) {
            if (this.clesPrivees != null && this.clesPrivees.get(string) != null) {
                this.clesPrivees.get(string).removeAllElements();
            }
        } else if (n == 4 && this.objets != null && this.objets.get(string) != null) {
            this.objets.get(string).removeAllElements();
        }
    }

    public void supprimeLaSession(String string, Session session) {
        if (string != null && session != null && string != null && this.sessions != null && this.sessions.get(string) != null) {
            this.sessions.get(string).remove(session);
            if (session == this.sessionCourante && this.sessions.get(string) != null && this.sessions.get(string).size() != 0) {
                this.sessionCourante = this.sessions.get(string).get(0);
            } else if (session == this.sessionCourante) {
                this.sessionCourante = null;
                Iterator<String> iterator = this.sessions.keySet().iterator();
                while (iterator.hasNext() && this.sessionCourante == null) {
                    String string2 = iterator.next();
                    if (string2.equalsIgnoreCase(string) || this.sessions.get(string2) == null || this.sessions.get(string2).size() == 0) continue;
                    this.sessionCourante = this.sessions.get(string2).get(0);
                }
            }
        }
    }

    public void supprimeToutesLesSessions(Token token) throws ExceptionObjet {
        if (this.sessions != null && token.getNumeroSerie() != null && this.sessions.get(token.getNumeroSerie()) != null) {
            this.sessions.get(token.getNumeroSerie()).removeAllElements();
        }
    }

    public int nbSessionsActives() {
        int n = 0;
        if (this.sessions != null && this.sessions.values() != null) {
            for (Vector<Session> vector : this.sessions.values()) {
                n += vector.size();
            }
        }
        return n;
    }

    public void supprimeApplicationEcouteur(ApplicationEcouteur applicationEcouteur) {
        if (this.ecouteurs != null) {
            this.ecouteurs.remove(ApplicationEcouteur.class, applicationEcouteur);
        }
    }

    public static String getTypeOS() {
        String string = System.getProperty("os.name").toLowerCase();
        if (string.indexOf("win") >= 0) {
            return "w" + System.getProperty("sun.arch.data.model");
        }
        if (string.indexOf("nix") >= 0 || string.indexOf("nux") >= 0) {
            return "lux";
        }
        if (string.indexOf("mac") >= 0) {
            return "mac";
        }
        return "";
    }

    public static FileFilter getFiltreLibrairie() {
        FileFilter fileFilter = new FileFilter(){

            public String getDescription() {
                if (Application.getTypeOS().equalsIgnoreCase("w32") || Application.getTypeOS().equalsIgnoreCase("w64")) {
                    return "Fichiers .dll uniquement";
                }
                if (Application.getTypeOS().equalsIgnoreCase("lux")) {
                    return "Fichiers .so uniquement";
                }
                if (Application.getTypeOS().equalsIgnoreCase("mac")) {
                    return "Fichiers .dylib uniquement";
                }
                return null;
            }

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = null;
                String string2 = file.getName();
                int n = string2.lastIndexOf(46);
                if (n > 0 && n < string2.length() - 1) {
                    string = string2.substring(n + 1).toLowerCase();
                }
                if (string != null) {
                    return string.equalsIgnoreCase("dll") && (Application.getTypeOS().equalsIgnoreCase("w32") || Application.getTypeOS().equalsIgnoreCase("w64")) || string.equalsIgnoreCase("so") && Application.getTypeOS().equalsIgnoreCase("lux") || string.equalsIgnoreCase("dylib") && Application.getTypeOS().equalsIgnoreCase("mac");
                }
                return false;
            }
        };
        return fileFilter;
    }
}

